/*======================================================================
 * DG121032.H    
 *======================================================================
 *
 * Name:        DG121032.H
 *
 *              Dearborn Group Inc.
 *              27007 Hills Tech Court
 *              Farmington Hills, MI  48331
 *              Phone (248) 488-2080
 *              Fax (248) 488-2082
 *              http://www.dgtech.com 
 *
 * Decription:  This file is used to develop RP1210A applications using
 *              the Dearborn Group Inc. DPA 4 Plus RP1210A-compliant drivers.
 *
 *              Intended for use with DPA III, DPA RF, DPA 4, and DPA 4 
				Plus series adapters.
 *
 *======================================================================
 * Revisions
 *
 * Date        Change
 * ----------------------------------------------------------------------
 * 
 *
 *======================================================================*/

//--------------------------------------------------------------
// RP1210A  RP1210_SendCommand Defines
//--------------------------------------------------------------

typedef unsigned char U8;

#define RP1210_Reset_Device                            0
#define RP1210_Set_All_Filters_States_to_Pass          3
#define RP1210_Set_Message_Filtering_For_J1939         4
#define RP1210_Set_Message_Filtering_For_CAN           5
#define RP1210_Set_Message_Filtering_For_J1708         7
#define RP1210_Generic_Driver_Command                 14
#define RP1210_Set_J1708_Mode                         15
#define RP1210_Echo_Transmitted_Messages              16
#define RP1210_Set_All_Filters_States_to_Discard      17
#define RP1210_Set_Message_Receive                    18
#define RP1210_Protect_J1939_Address                  19
//--------------------------------------------------------------
// RP1210A Constants
//--------------------------------------------------------------


#define NULL_WINDOW                                   0  // Windows 3.1 is no longer supported.

#define BLOCKING_IO                                   1  // For Blocking calls to send/read.
#define NON_BLOCKING_IO                               0  // For Non-Blocking calls to send/read.

#define CONVERTED_MODE                                1  // RP1210Mode="Converted"
#define RAW_MODE                                      0  // RP1210Mode="Raw"

#define MAX_J1708_MESSAGE_LENGTH                    508  // Maximum size a J1708 message can be (+1)
#define MAX_J1939_MESSAGE_LENGTH                   1796  // Maximum size a J1939 message can be (+1)
#define MAX_J1850_MESSAGE_LENGTH					508  // Maximum size a J1850 message can be
#define CAN_DATA_SIZE								  8  // Maximum data size a CAN message can be

#define ECHO_OFF                                   0x00  // EchoMode
#define ECHO_ON                                    0x01  // EchoMode

#define RECEIVE_ON                                 0x01  // Set Message Receive
#define RECEIVE_OFF                                0x00  // Set Message Receive


#define FILTER_PGN                           0x00000001  // Setting of J1939 filters
#define FILTER_PRIORITY                      0x00000002  // Setting of J1939 filters
#define FILTER_SOURCE                        0x00000004  // Setting of J1939 filters
#define FILTER_DESTINATION                   0x00000008  // Setting of J1939 filters

#define SILENT_J1939_CLAIM                         0x00  // Claim J1939 Address
#define PASS_J1939_CLAIM_MESSAGES                  0x01  // Claim J1939 Address

#define STANDARD_CAN                               0x00  // Filters
#define EXTENDED_CAN                               0x01  // Filters

#ifndef TRUE
#define TRUE                                       0x01
#define FALSE                                      0x00
#endif
//--------------------------------------------------------------
// RP1210A Return Definitions
//--------------------------------------------------------------
#define NO_ERRORS                                          0
#define ERR_DLL_NOT_INITIALIZED                          128
#define ERR_INVALID_CLIENT_ID                            129
#define ERR_CLIENT_ALREADY_CONNECTED                     130
#define ERR_CLIENT_AREA_FULL                             131
#define ERR_FREE_MEMORY                                  132
#define ERR_NOT_ENOUGH_MEMORY                            133
#define ERR_INVALID_DEVICE                               134
#define ERR_DEVICE_IN_USE                                135
#define ERR_INVALID_PROTOCOL                             136
#define ERR_TX_QUEUE_FULL                                137
#define ERR_TX_QUEUE_CORRUPT                             138
#define ERR_RX_QUEUE_FULL                                139
#define ERR_RX_QUEUE_CORRUPT                             140
#define ERR_MESSAGE_TOO_LONG                             141
#define ERR_HARDWARE_NOT_RESPONDING                      142
#define ERR_COMMAND_NOT_SUPPORTED                        143
#define ERR_INVALID_COMMAND                              144
#define ERR_TXMESSAGE_STATUS                             145
#define ERR_ADDRESS_CLAIM_FAILED                         146
#define ERR_CANNOT_SET_PRIORITY                          147
#define ERR_CLIENT_DISCONNECTED                          148
#define ERR_CONNECT_NOT_ALLOWED                          149
#define ERR_CHANGE_MODE_FAILED                           150
#define ERR_BUS_OFF                                      151
#define ERR_COULD_NOT_TX_ADDRESS_CLAIMED                 152
#define ERR_ADDRESS_LOST                                 153
#define ERR_CODE_NOT_FOUND                               154
#define ERR_BLOCK_NOT_ALLOWED                            155
#define ERR_MULTIPLE_CLIENTS_CONNECTED                   156
#define ERR_ADDRESS_NEVER_CLAIMED                        157
#define ERR_WINDOW_HANDLE_REQUIRED                       158
#define ERR_MESSAGE_NOT_SENT                             159
#define ERR_MAX_NOTIFY_EXCEEDED                          160
#define ERR_MAX_FILTERS_EXCEEDED                         161
#define ERR_HARDWARE_STATUS_CHANGE                       162
#define ERR_INI_FILE_NOT_IN_WIN_DIR                      202
#define ERR_INI_SECTION_NOT_FOUND                        204
#define ERR_INI_KEY_NOT_FOUND                            205
#define ERR_INVALID_KEY_STRING                           206
#define ERR_DEVICE_NOT_SUPPORTED                         207
#define ERR_INVALID_PORT_PARAM                           208
#define ERR_COMMAND_TIMED_OUT                            213
#define ERR_OS_NOT_SUPPORTED                             220
#define ERR_COMMAND_QUEUE_IS_FULL                        222
#define ERR_CANNOT_SET_CAN_BAUDRATE                      224
#define ERR_CANNOT_CLAIM_BROADCAST_ADDRESS               225
#define ERR_OUT_OF_ADDRESS_RESOURCES                     226
#define ERR_ADDRESS_RELEASE_FAILED                       227
#define ERR_COMM_DEVICE_IN_USE                           230
#define DG_DLL_NOT_FOUND								 254
#define DG_BUSY_SENDING									 255

//--------------------------------------------------------------
// TMC RP1210A Defined Function Prototypes
//--------------------------------------------------------------

#define DLLEXPORT __declspec(dllexport)

#ifdef __cplusplus
extern "C" {
#endif
short DLLEXPORT WINAPI RP1210_ClientConnect(  
                                HWND   hwndClient,
                                short  nDeviceId,
                                char  *fpchProtocol,
                                long   lSendBuffer,
                                long   lReceiveBuffer,
                                short  nIsAppPacketizingIncomingMsgs );

short DLLEXPORT WINAPI RP1210_ClientDisconnect( short  nClientID );

short DLLEXPORT WINAPI RP1210_SendMessage(  
                                short  nClientID,
                                char  *fpchClientMessage,
                                short  nMessageSize,
                                short  nNotifyStatusOnTx,
                                short  nBlockOnSend );

short DLLEXPORT WINAPI RP1210_ReadMessage(  
                                short  nClientID,
                                char  *fpchAPIMessage,
                                short  nBufferSize,
                                short  nBlockOnSend );

short DLLEXPORT WINAPI RP1210_SendCommand(  
                                short  nCommandNumber,
                                short  nClientID,
                                char  *fpchClientCommand,
                                short  nMessageSize );

void  DLLEXPORT WINAPI RP1210_ReadVersion(  
                                char  *fpchDLLMajorVersion,
                                char  *fpchDLLMinorVersion,
                                char  *fpchAPIMajorVersion,
                                char  *fpchAPIMinorVersion );

short  DLLEXPORT WINAPI RP1210_ReadDetailedVersion(  
                                short  nClientID,
                                char *fpchAPIVersionInfo,
                                char *fpchDLLVersionInfo,
                                char *fpchFWVersionInfo );

short DLLEXPORT WINAPI RP1210_GetHardwareStatus(  
                                short  nClientID,
                                char  *fpchClientInfo,
                                short  nInfoSize,
                                short  nBlockOnRequest);

short DLLEXPORT WINAPI RP1210_GetErrorMsg( 
                                short  err_code,
                                char  *fpchMessage,
                                short  nClientID );

#ifdef __cplusplus
}
#endif

